----------
-- DATA --
----------

gHost = "127.0.0.1"
gPort = 9089
gExportInterval = 0.1
gExportLowTickInterval = 1

gA10EveryFrameArguments = {[540]="%0.1f", [541]="%0.1f", [542]="%0.1f", [730]="%0.1f", [731]="%0.1f", [732]="%0.1f", [76]="%.4f", [77]="%.4f", [78]="%.4f", [80]="%.4f", [84]="%.4f", [85]="%.4f", [70]="%.4f", [73]="%.4f", [82]="%.4f", [83]="%.4f", [13]="%.4f", [14]="%.4f", [48]="%.4f", [12]="%.4f", [4]="%.4f", [55]="%0.1f", [17]="%.4f", [18]="%.4f", [24]="%.4f", [23]="%.4f", [25]="%0.1f", [19]="%0.1f", [26]="%0.1f", [20]="%.4f", [21]="%.4f", [27]="%.4f", [63]="%.4f", [64]="%.4f", [65]="%0.1f", [715]="%.4f", [40]="%0.1f", [32]="%0.1f", [46]="%0.1f", [34]="%.4f", [36]="%.4f", [47]="%.4f", [41]="%.4f", [33]="%.4f", [35]="%.4f", [662]="%0.1f", [663]="%0.1f", [665]="%0.1f", [664]="%0.1f", [215]="%0.1f", [216]="%0.1f", [217]="%0.1f", [404]="%0.1f", [372]="%0.1f", [373]="%0.1f", [374]="%0.1f", [654]="%1d", [659]="%0.1f", [660]="%0.1f", [661]="%0.1f", [737]="%0.1f", [653]="%.4f", [88]="%.4f", [89]="%.4f", [647]="%.4f", [648]="%.4f", [606]="%0.1f", [608]="%0.1f", [610]="%0.1f", [612]="%0.1f", [614]="%0.1f", [616]="%0.1f", [618]="%0.1f", [619]="%0.1f", [620]="%0.1f", [274]="%.4f", [604]="%.4f", [600]="%0.1f", [281]="%.4f", [289]="%1d", [480]="%0.1f", [481]="%0.1f", [482]="%0.1f", [483]="%0.1f", [484]="%0.1f", [485]="%0.1f", [486]="%0.1f", [487]="%0.1f", [488]="%0.1f", [489]="%0.1f", [490]="%0.1f", [491]="%0.1f", [492]="%0.1f", [493]="%0.1f", [494]="%0.1f", [495]="%0.1f", [496]="%0.1f", [497]="%0.1f", [498]="%0.1f", [499]="%0.1f", [500]="%0.1f", [501]="%0.1f", [502]="%0.1f", [503]="%0.1f", [504]="%0.1f", [505]="%0.1f", [506]="%0.1f", [507]="%0.1f", [508]="%0.1f", [509]="%0.1f", [510]="%0.1f", [511]="%0.1f", [512]="%0.1f", [513]="%0.1f", [514]="%0.1f", [515]="%0.1f", [516]="%0.1f", [517]="%0.1f", [518]="%0.1f", [519]="%0.1f", [520]="%0.1f", [521]="%0.1f", [522]="%0.1f", [523]="%0.1f", [524]="%0.1f", [525]="%0.1f", [526]="%0.1f", [527]="%0.1f", [260]="%0.1f", [269]="%.4f", [129]="%1d", [185]="%1d", [186]="%1d", [187]="%1d", [188]="%1d", [191]="%0.1f", [798]="%0.1f", [799]="%0.1f", [178]="%0.1f", [179]="%0.1f", [181]="%0.1f", [182]="%0.1f"}
gA10Arguments = {[22]="%.3f", [101]="%.1f", [102]="%1d", [103]="%1d", [104]="%1d", [105]="%1d", [300]="%.1f", [301]="%.1f", [302]="%.1f", [303]="%.1f", [304]="%.1f", [305]="%.1f", [306]="%.1f", [307]="%.1f", [308]="%.1f", [309]="%.1f", [310]="%.1f", [311]="%.1f", [312]="%.1f", [313]="%.1f", [314]="%.1f", [315]="%.1f", [316]="%.1f", [317]="%.1f", [318]="%.1f", [319]="%.1f", [320]="%1d", [321]="%1d", [322]="%1d", [323]="%1d", [324]="%1d", [325]="%0.1f", [326]="%.1f", [327]="%.1f", [328]="%.1f", [329]="%.1f", [330]="%.1f", [331]="%.1f", [332]="%.1f", [333]="%.1f", [334]="%.1f", [335]="%.1f", [336]="%.1f", [337]="%.1f", [338]="%.1f", [339]="%.1f", [340]="%.1f", [341]="%.1f", [342]="%.1f", [343]="%.1f", [344]="%.1f", [345]="%.1f", [346]="%1d", [347]="%1d", [348]="%1d", [349]="%1d", [350]="%1d", [351]="%0.1f", [385]="%.1f", [386]="%.1f", [387]="%.1f", [388]="%.1f", [389]="%.1f", [390]="%.1f", [391]="%.1f", [392]="%.1f", [393]="%.1f", [395]="%.1f", [396]="%.1f", [394]="%.1f", [397]="%.1f", [398]="%.1f", [399]="%.1f", [400]="%.1f", [401]="%.1f", [402]="%.1f", [405]="%1d", [406]="%1d", [407]="%1d", [408]="%1d", [409]="%1d", [531]="%.1f", [532]="%.1f", [533]="%.1f", [403]="%.1f", [365]="%.1f", [366]="%.1f", [369]="%.1f", [370]="%.1f", [371]="%.1f", [367]="%.3f", [368]="%.3f", [716]="%1d", [655]="%0.1f", [651]="%.1f", [375]="%0.1f", [376]="%0.1f", [377]="%0.1f", [378]="%1d", [379]="%0.1f", [380]="%1d", [381]="%1d", [382]="%1d", [383]="%1d", [384]="%0.1f", [645]="%0.1f", [646]="%.1f", [605]="%.1f", [607]="%.1f", [609]="%.1f", [611]="%.1f", [613]="%.1f", [615]="%.1f", [617]="%.1f", [621]="%1d", [711]="%.1f", [622]="%0.1f", [623]="%1d", [624]="%.3f", [626]="%.3f", [636]="%0.2f", [638]="%0.2f", [640]="%0.2f", [642]="%0.2f", [644]="%1d", [628]="%.1f", [630]="%.1f", [632]="%.1f", [634]="%.1f", [410]="%.1f", [411]="%.1f", [412]="%.1f", [413]="%.1f", [414]="%.1f", [415]="%.1f", [416]="%.1f", [417]="%.1f", [418]="%.1f", [419]="%.1f", [420]="%.1f", [421]="%.1f", [422]="%.1f", [423]="%.1f", [425]="%.1f", [426]="%.1f", [427]="%.1f", [428]="%.1f", [429]="%.1f", [430]="%.1f", [431]="%.1f", [432]="%.1f", [433]="%.1f", [434]="%.1f", [435]="%.1f", [436]="%.1f", [437]="%.1f", [438]="%.1f", [439]="%.1f", [440]="%.1f", [441]="%.1f", [442]="%.1f", [443]="%.1f", [444]="%.1f", [445]="%.1f", [446]="%.1f", [447]="%.1f", [448]="%.1f", [449]="%.1f", [450]="%.1f", [451]="%.1f", [452]="%.1f", [453]="%.1f", [454]="%.1f", [455]="%.1f", [456]="%.1f", [457]="%.1f", [458]="%.1f", [459]="%.1f", [460]="%.1f", [461]="%.1f", [462]="%.1f", [466]="%.1f", [467]="%.1f", [468]="%.1f", [470]="%.1f", [471]="%.1f", [424]="%1d", [463]="%1d", [469]="%1d", [472]="%1d", [241]="%1d", [242]="%1d", [243]="%1d", [244]="%1d", [245]="%1d", [246]="%1d", [601]="%1d", [602]="%1d", [603]="%1d", [712]="%0.2f", [352]="%.1f", [353]="%.1f", [354]="%.1f", [355]="%.1f", [356]="%1d", [357]="%.1f", [358]="%1d", [359]="%.3f", [360]="%0.1f", [361]="%0.1f", [362]="%0.1f", [363]="%0.1f", [364]="%0.1f", [275]="%.1f", [276]="%1d", [277]="%.3f", [278]="%1d", [279]="%1d", [280]="%1d", [282]="%1d", [283]="%1d", [284]="%.3f", [287]="%1d", [288]="%.3f", [290]="%.3f", [291]="%1d", [292]="%.3f", [293]="%.3f", [294]="%1d", [295]="%1d", [296]="%.3f", [297]="%.3f", [258]="%0.2f", [259]="%.1f", [261]="%.3f", [262]="%0.1f", [266]="%1d", [247]="%1d", [248]="%0.1f", [250]="%0.1f", [249]="%.3f", [251]="%0.1f", [252]="%0.1f", [270]="%1d", [273]="%1d", [272]="%1d", [271]="%.3f", [267]="%.1f", [268]="%.3f", [473]="%0.1f", [474]="%1d", [475]="%0.1f", [476]="%1d", [477]="%1d", [106]="%1d", [107]="%1d", [108]="%1d", [109]="%1d", [110]="%1d", [111]="%1d", [112]="%1d", [113]="%1d", [114]="%1d", [115]="%.1f", [117]="%1d", [118]="%1d", [119]="%1d", [120]="%1d", [121]="%1d", [116]="%.3f", [122]="%1d", [123]="%1d", [124]="%1d", [125]="%1d", [126]="%1d", [127]="%.1f", [132]="%1d", [131]="%.1f", [130]="%1d", [137]="%0.3f", [138]="%0.1f", [135]="%0.1f", [133]="%.3f", [136]="%.1f", [134]="%1d", [139]="%0.2f", [140]="%0.2f", [141]="%0.2f", [142]="%0.2f", [151]="%0.3f", [153]="%0.2f", [154]="%0.2f", [155]="%0.2f", [156]="%0.2f", [152]="%0.1f", [149]="%0.1f", [147]="%.3f", [150]="%.1f", [148]="%1d", [189]="%1d", [190]="%.1f", [192]="%.3f", [197]="%.1f", [196]="%1d", [193]="%.3f", [195]="%.3f", [194]="%0.1f", [198]="%.1f", [161]="%0.2f", [162]="%0.1f", [163]="%0.2f", [164]="%0.2f", [165]="%0.2f", [166]="%0.2f", [167]="%0.1f", [168]="%0.1f", [169]="%1d", [170]="%1d", [171]="%.3f", [172]="%.1f", [173]="%.1f", [735]="%.1f", [734]="%1d", [779]="%1d", [778]="%1d", [780]="%1d", [781]="%0.1f", [782]="%0.1f", [783]="%0.1f", [784]="%1d", [772]="%1d", [199]="%0.1f", [200]="%0.1f", [201]="%1d", [202]="%1d", [203]="%1d", [204]="%1d", [205]="%1d", [206]="%1d", [207]="%1d", [208]="%1d", [209]="%0.2f", [210]="%0.2f", [211]="%0.2f", [212]="%0.2f", [213]="%0.2f", [214]="%0.2f", [174]="%1d", [175]="%1d", [176]="%0.1f", [177]="%1d", [180]="%1d", [183]="%1d", [184]="%1d", [221]="%.3f", [222]="%1d", [223]="%.3f", [224]="%1d", [225]="%.3f", [226]="%1d", [227]="%.3f", [228]="%1d", [229]="%.3f", [230]="%1d", [231]="%.3f", [232]="%1d", [233]="%.3f", [234]="%1d", [235]="%.3f", [236]="%1d", [237]="%1d", [238]="%.3f", [239]="%0.1f", [240]="%.1f", [704]="%.3f", [705]="%.3f", [718]="%1d", [722]="%.1f", [733]="%1d"}

gKa50EveryFrameArguments = {[44]="%0.1f", [46]="%0.1f", [47]="%0.1f", [48]="%0.1f", [78]="%0.1f", [79]="%0.1f", [80]="%0.1f", [81]="%0.1f", [82]="%0.1f", [83]="%0.1f", [84]="%0.1f", [85]="%0.1f", [86]="%0.1f", [24]="%.4f", [100]="%.4f", [101]="%.4f", [102]="%0.1f", [109]="%0.1f", [107]="%.4f", [106]="%.4f", [111]="%.4f", [103]="%.4f", [526]="%.4f", [108]="%.4f", [87]="%.4f", [88]="%0.2f", [89]="%.4f", [112]="%.4f", [118]="%.4f", [124]="%.4f", [115]="%.4f", [119]="%0.1f", [114]="%0.1f", [125]="%0.1f", [117]="%0.4f", [527]="%0.4f", [528]="%0.4f", [127]="%.4f", [128]="%.4f", [116]="%0.1f", [121]="%0.1f", [53]="%.4f", [52]="%.4f", [94]="%.4f", [93]="%.4f", [95]="%0.1f", [92]="%0.1f", [51]="%.4f", [97]="%0.2f", [98]="%0.2f", [99]="%0.2f", [68]="%.4f", [69]="%.4f", [70]="%.4f", [75]="%0.1f", [72]="%.4f", [531]="%.4f", [73]="%.4f", [532]="%.4f", [142]="%.4f", [143]="%.4f", [144]="%.4f", [145]="%0.1f", [133]="%.4f", [134]="%.4f", [135]="%.4f", [136]="%.4f", [138]="%.4f", [137]="%.4f", [139]="%0.1f", [140]="%0.1f", [392]="%0.1f", [393]="%0.1f", [394]="%0.1f", [395]="%0.1f", [388]="%0.1f", [389]="%0.1f", [390]="%0.1f", [391]="%0.1f", [63]="%0.1f", [64]="%0.1f", [61]="%0.1f", [62]="%0.1f", [59]="%0.1f", [60]="%0.1f", [170]="%0.1f", [175]="%0.1f", [172]="%0.1f", [165]="%0.1f", [171]="%0.1f", [176]="%0.1f", [166]="%0.1f", [164]="%0.1f", [178]="%0.1f", [173]="%0.1f", [177]="%0.1f", [211]="%0.1f", [187]="%0.1f", [204]="%0.1f", [213]="%0.1f", [11]="%.4f", [12]="%.4f", [14]="%.4f", [167]="%0.1f", [180]="%0.1f", [179]="%0.1f", [188]="%0.1f", [189]="%0.1f", [206]="%0.1f", [212]="%0.1f", [205]="%0.1f", [181]="%0.1f", [190]="%0.1f", [207]="%0.1f", [183]="%0.1f", [182]="%0.1f", [191]="%0.1f", [208]="%0.1f", [184]="%0.1f", [200]="%0.1f", [209]="%0.1f", [185]="%0.1f", [202]="%0.1f", [201]="%0.1f", [210]="%0.1f", [186]="%0.1f", [203]="%0.1f", [159]="%0.1f", [150]="%0.1f", [161]="%0.1f", [15]="%0.1f", [16]="%0.1f", [17]="%0.1f", [18]="%0.1f", [19]="%0.1f", [20]="%0.1f", [21]="%0.1f", [22]="%0.1f", [23]="%0.1f", [50]="%0.1f", [25]="%0.1f", [28]="%0.1f", [26]="%0.1f", [27]="%0.1f", [31]="%0.1f", [32]="%0.1f", [33]="%0.1f", [34]="%0.1f", [582]="%0.1f", [541]="%0.1f", [542]="%0.1f", [315]="%0.1f", [519]="%0.1f", [316]="%0.1f", [520]="%0.1f", [317]="%0.1f", [521]="%0.1f", [318]="%0.1f", [313]="%0.1f", [314]="%0.1f", [522]="%0.1f", [319]="%0.1f", [320]="%0.1f", [321]="%0.1f", [322]="%0.1f", [323]="%0.1f", [330]="%0.1f", [332]="%0.1f", [331]="%0.1f", [333]="%0.1f", [334]="%0.1f", [375]="%0.1f", [419]="%0.1f", [577]="%.3f", [574]="%.2f", [575]="%.2f", [576]="%.2f", [437]="%0.1f", [438]="%0.1f", [439]="%0.1f", [440]="%0.1f", [441]="%0.1f", [163]="%0.1f", [162]="%0.1f", [168]="%0.1f", [169]="%0.1f", [174]="%0.1f", [6]="%.4f", [586]="%0.1f", [261]="%0.1f", [461]="%0.1f", [237]="%0.1f", [239]="%0.1f", [568]="%0.1f", [241]="%0.1f", [243]="%0.1f", [244]="%0.1f", [245]="%0.1f", [592]="%.4f", [234]="%0.2f", [235]="%0.2f", [252]="%.4f", [253]="%.4f", [254]="%.4f", [255]="%.4f", [256]="%.4f", [257]="%.4f", [469]="%0.1f", [470]="%0.1f", [471]="%.4f", [472]="%.4f", [473]="%.4f", [474]="%.4f", [475]="%.4f", [476]="%.4f", [342]="%0.1f", [339]="%0.4f", [594]="%0.4f", [337]="%0.4f", [596]="%0.4f"}
gKa50Arguments = {[110]="%.1f", [113]="%.1f", [54]="%1d", [56]="%1d", [57]="%1d", [55]="%.1f", [96]="%.1f", [572]="%.1f", [45]="%.1f", [230]="%1d", [131]="%.1f", [132]="%.1f", [616]="%.1f", [512]="%.1f", [513]="%.1f", [514]="%.1f", [515]="%.1f", [516]="%.1f", [523]="%.1f", [517]="%.3f", [130]="%0.1f", [8]="%.3f", [9]="%1d", [7]="%.1f", [510]="%0.1f", [387]="%1d", [402]="%.1f", [396]="%1d", [403]="%1d", [399]="%1d", [400]="%0.1f", [398]="%1d", [397]="%.1f", [404]="%1d", [406]="%.3f", [407]="%.3f", [405]="%.3f", [408]="%0.1f", [409]="%1d", [382]="%0.1f", [383]="%1d", [381]="%0.2f", [384]="%.1f", [385]="%.1f", [386]="%0.1f", [442]="%.1f", [65]="%1d", [66]="%1d", [67]="%1d", [146]="%0.1f", [147]="%0.1f", [539]="%1d", [151]="%1d", [153]="%1d", [154]="%0.1f", [156]="%.1f", [35]="%.1f", [583]="%1d", [584]="%.1f", [36]="%0.1f", [37]="%0.1f", [38]="%.1f", [39]="%.1f", [41]="%.1f", [43]="%.1f", [42]="%.1f", [40]="%.1f", [496]="%1d", [497]="%1d", [498]="%1d", [499]="%1d", [312]="%0.1f", [303]="%0.1f", [304]="%0.1f", [305]="%0.1f", [306]="%0.1f", [307]="%0.1f", [308]="%0.1f", [309]="%0.1f", [310]="%0.1f", [311]="%0.1f", [324]="%0.1f", [325]="%1d", [326]="%1d", [327]="%.3f", [328]="%0.1f", [329]="%0.1f", [335]="%0.1f", [336]="%0.1f", [355]="%.1f", [354]="%1d", [353]="%.3f", [356]="%1d", [357]="%0.1f", [371]="%0.1f", [372]="%.3f", [373]="%.1f", [374]="%1d", [376]="%.1f", [377]="%.1f", [378]="%.1f", [379]="%.1f", [380]="%1d", [418]="%.1f", [417]="%1d", [421]="%1d", [422]="%1d", [420]="%1d", [423]="%1d", [432]="%1d", [431]="%0.1f", [436]="%1d", [433]="%1d", [435]="%1d", [434]="%1d", [412]="%.1f", [413]="%.1f", [414]="%.1f", [415]="%0.1f", [416]="%0.1f", [428]="%0.2f", [554]="%1d", [555]="%1d", [556]="%1d", [301]="%0.1f", [224]="%.1f", [262]="%1d", [263]="%1d", [543]="%1d", [544]="%1d", [264]="%1d", [265]="%1d", [267]="%1d", [268]="%1d", [269]="%1d", [270]="%01.f", [271]="%1d", [272]="%1d", [273]="%1d", [274]="%1d", [275]="%1d", [276]="%1d", [277]="%1d", [278]="%1d", [279]="%1d", [280]="%1d", [281]="%1d", [282]="%1d", [283]="%1d", [284]="%1d", [285]="%1d", [286]="%1d", [287]="%1d", [288]="%1d", [289]="%1d", [547]="%1d", [548]="%1d", [214]="%1d", [215]="%1d", [216]="%1d", [217]="%1d", [462]="%0.1f", [460]="%.1f", [220]="%1d", [221]="%1d", [218]="%1d", [219]="%1d", [222]="%1d", [229]="%0.1f", [228]="%1d", [296]="%1d", [297]="%0.1f", [290]="%1d", [291]="%1d", [292]="%1d", [293]="%1d", [294]="%1d", [569]="%1d", [295]="%0.1f", [570]="%0.1f", [457]="%.1f", [458]="%.1f", [459]="%.1f", [300]="%1d", [299]="%1d", [298]="%1d", [236]="%.1f", [238]="%.1f", [240]="%.1f", [242]="%.1f", [248]="%0.1f", [249]="%0.1f", [250]="%1d", [246]="%1d", [247]="%1d", [258]="%0.1f", [259]="%1d", [483]="%0.1f", [484]="%0.1f", [485]="%1d", [486]="%1d", [489]="%.1f", [490]="%1d", [491]="%1d", [492]="%1d", [487]="%1d", [488]="%1d", [452]="%1d", [453]="%1d", [340]="%.3f", [341]="%1d", [338]="%.3f"}

-- Lookup tables for weapons store type display
gKa50StationTypes = {["9A4172"] = "NC", ["S-8KOM"] = "HP", ["S-13"] = "HP", ["UPK-23-250"] = "NN", ["AO-2.5RT"] = "A6", ["PTAB-2.5KO"] = "A6",
				 ["FAB-250"] = "A6", ["FAB-500"] = "A6" }

-- State data
gKa50Trigger = 0


---------------
-- FUNCTIONS --
---------------

-- HIGH IMPORTANCE EXPORTS --

-- Pointed to by ProcessHighImportance, if the player aircraft is an A-10
function ProcessA10HighImportance(mainPanelDevice)
	-- Send Altimeter Values	
	SendData(2051, string.format("%0.4f;%0.4f;%0.5f", mainPanelDevice:get_argument_value(52), mainPanelDevice:get_argument_value(53), mainPanelDevice:get_argument_value(51)))
	SendData(2059, string.format("%0.2f;%0.2f;%0.2f;%0.3f", mainPanelDevice:get_argument_value(56), mainPanelDevice:get_argument_value(57), mainPanelDevice:get_argument_value(58), mainPanelDevice:get_argument_value(59)))		
	-- Calcuate HSI Value
	SendData(2029, string.format("%0.2f;%0.2f;%0.4f", mainPanelDevice:get_argument_value(29), mainPanelDevice:get_argument_value(30), mainPanelDevice:get_argument_value(31)))
	-- Calculate Total Fuel
	SendData(2090, string.format("%0.2f;%0.2f;%0.5f", mainPanelDevice:get_argument_value(90), mainPanelDevice:get_argument_value(91), mainPanelDevice:get_argument_value(92)))
end

-- Pointed to by ProcessHighImportance, if the player aircraft is something else
function ProcessNoHighImportance(mainPanelDevice)
end


-- LOW IMPORTANCE EXPORTS --

-- Pointed to by ProcessLowImportance, if the player aircraft is an A-10
function ProcessA10LowImportance(mainPanelDevice)
	-- Get Radio Frequencies
	local lUHFRadio = GetDevice(54)
	SendData(2000, string.format("%7.3f", lUHFRadio:get_frequency()/1000000))
	-- ILS Frequency
	--SendData(2251, string.format("%0.1f;%0.1f", mainPanelDevice:get_argument_value(251), mainPanelDevice:get_argument_value(252)))
	-- TACAN Channel
	SendData(2263, string.format("%0.2f;%0.2f;%0.2f", mainPanelDevice:get_argument_value(263), mainPanelDevice:get_argument_value(264), mainPanelDevice:get_argument_value(265)))
end

-- Pointed to by ProcessLowImportance, if the player aircraft is a Ka-50
function ProcessKa50LowImportance(mainPanelDevice)
	local lWeaponSystem = GetDevice(12)
	local lEKRAN = GetDevice(10)
	local lCannonAmmoCount = " "
	local lStationNumbers = lWeaponSystem:get_selected_weapon_stations()
	local lStationCount = " "
	local lStationType = " "	
	local lTargetingPower = mainPanelDevice:get_argument_value(433)
	local lTrigger = mainPanelDevice:get_argument_value(615)
	if lTrigger == 0 then
		gKa50Trigger = 1
	end
	if lTrigger == -1 then
		gKa50Trigger = 0
	end

	if lTargetingPower == 1 then
		lCannonAmmoCount = string.format("%02d",string.match(lWeaponSystem:get_selected_gun_ammo_count() / 10,"(%d+)"))
	
		if #lStationNumbers ~= 0 and gKa50Trigger == 0 then
			lStationCount = 0
			for i=1,#lStationNumbers do
				lStationCount = lStationCount + lWeaponSystem:get_weapon_count_on_station(lStationNumbers[i])
			end
			
			lStationCount = string.format("%02d", lStationCount);
			
			lStationType = gKa50StationTypes[lWeaponSystem:get_weapon_type_on_station(lStationNumbers[1])]
			if lStationType == nil then
				lStationType = " "
			end
		end
	end

	local lEkranText = lEKRAN:get_actual_text_frame()
	local lEkranSendString = string.sub(lEkranText,1,8).."\n"..string.sub(lEkranText,12,19).."\n"..string.sub(lEkranText,23,30).."\n"..string.sub(lEkranText,34,41) 
	
	SendData("2001",lStationType)
	SendData("2002",lStationCount)
	SendData("2003",lCannonAmmoCount)
	SendData("2004",lEkranSendString)
end

-- Pointed to by ProcessLowImportance, if the player aircraft is something else
function ProcessNoLowImportance(mainPanelDevice)
end


------------
-- SCRIPT --
------------

os.setlocale("ISO-8559-1", "numeric")

-- Simulation id
gSimID = string.format("%08x*",os.time())

-- State data for export
gPacketSize = 0
gSendStrings = {}
gLastData = {}

-- Frame counter for non important data
gTickCount = 0


---------------------------------------------
-- DCS Export API Function Implementations --
---------------------------------------------

function LuaExportStart()
-- Works once just before mission start.
-- (and before player selects their aircraft, if there is a choice!)
	
    -- 2) Setup udp sockets to talk to helios
    package.path  = package.path..";.\\LuaSocket\\?.lua"
    package.cpath = package.cpath..";.\\LuaSocket\\?.dll"
   
    socket = require("socket")
    
    c = socket.udp()
	c:setsockname("*", 0)
	c:setoption('broadcast', true)
    c:settimeout(.001) -- set the timeout for reading the socket

end

function LuaExportBeforeNextFrame()
	ProcessInput()
end

function LuaExportAfterNextFrame()	
end

function LuaExportStop()
-- Works once just after mission stop.
    c:close()
end

function ProcessInput()
    local lInput = c:receive()
    local lCommand, lCommandArgs, lDevice, lArgument, lLastValue
    
    if lInput then
	
        lCommand = string.sub(lInput,1,1)
        
		if lCommand == "R" then
			ResetChangeValues()
		end
	
		if (lCommand == "C") then
			lCommandArgs = StrSplit(string.sub(lInput,2),",")
			lDevice = GetDevice(lCommandArgs[1])
			if type(lDevice) == "table" then
				lDevice:performClickableAction(lCommandArgs[2],lCommandArgs[3])	
			end
		end
    end 
end

function LuaExportActivityNextEvent(t)
	t = t + gExportInterval

	gTickCount = gTickCount + 1

	local lDevice = GetDevice(0)
	if type(lDevice) == "table" then

		SelectAircraft() -- point globals to A10 or Ka-50 functions and data.

		lDevice:update_arguments()

		ProcessArguments(lDevice, gEveryFrameArguments) -- A10 or Ka50 arguments as appropriate
		ProcessHighImportance(lDevice) -- A10 or Ka-50, as appropriate; determined in SelectAircraft()

		if gTickCount >= gExportLowTickInterval then
			ProcessArguments(lDevice, gArguments) -- A10 or Ka50 arguments as appropriate
			ProcessLowImportance(lDevice) -- A10 or Ka-50 as appropriate; determined in SelectAircraft()
			gTickCount = 0
		end

		FlushData()
	end

	return t
end

-- Helper Functions
function StrSplit(str, delim, maxNb)
    -- Eliminate bad cases...
    if string.find(str, delim) == nil then
        return { str }
    end
    if maxNb == nil or maxNb < 1 then
        maxNb = 0    -- No limit
    end
    local result = {}
    local pat = "(.-)" .. delim .. "()"
    local nb = 0
    local lastPos
    for part, pos in string.gfind(str, pat) do
        nb = nb + 1
        result[nb] = part
        lastPos = pos
        if nb == maxNb then break end
    end
    -- Handle the last field
    if nb ~= maxNb then
        result[nb + 1] = string.sub(str, lastPos)
    end
    return result
end

function round(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end


-- Status Gathering Functions

function ProcessArguments(device, arguments)
	local lArgument , lFormat , lArgumentValue
		
	for lArgument, lFormat in pairs(arguments) do 
		lArgumentValue = string.format(lFormat,device:get_argument_value(lArgument))
		SendData(lArgument, lArgumentValue)
	end
end

-- Network Functions
function SendData(id, value)	
	if string.len(value) > 3 and value == string.sub("-0.00000000",1, string.len(value)) then
		value = value:sub(2)
	end
	
	if gLastData[id] == nil or gLastData[id] ~= value then
		local data =  id .. "=" .. value
		local dataLen = string.len(data)

		if dataLen + gPacketSize > 576 then
			FlushData()
		end

		table.insert(gSendStrings, data)
		gLastData[id] = value	
		gPacketSize = gPacketSize + dataLen + 1
	end	
end

function FlushData()
	if #gSendStrings > 0 then
		local packet = gSimID .. table.concat(gSendStrings, ":") .. "\n"
		socket.try(c:sendto(packet, gHost, gPort))
		gSendStrings = {}
		gPacketSize = 0
	end
end

function ResetChangeValues()
	gLastData = {}
	gTickCount = 10
end


function SelectAircraft()

   -- Select aircraft...

   local myInfo = LoGetSelfData()

   if myInfo.Name == "A-10C" then
     gEveryFrameArguments = gA10EveryFrameArguments
     gArguments = gA10Arguments 
     ProcessHighImportance = ProcessA10HighImportance
     ProcessLowImportance =  ProcessA10LowImportance
   elseif myInfo.Name == "Ka-50" then
     gEveryFrameArguments = gKa50EveryFrameArguments
     gArguments = gKa50Arguments 
     ProcessHighImportance = ProcessNoHighImportance
     ProcessLowImportance =  ProcessKa50LowImportance
   else -- Unknown aircraft
     ProcessHighImportance = ProcessNoHighImportance
     ProcessLowImportance =  ProcessNoLowImportance
     -- DEBUGGING STUFF:
     local default_output_file = io.open("./ExportDebug.log", "w")
     if myInfo and default_output_file then
       default_output_file:write("Unknown Plane Name: "..myInfo.Name..'\n')
     end
   end

end
